<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once '../../config/database.php';
require_once '../../models/WithdrawalRequest.php';

$database = new Database();
$db = $database->getConnection();

$withdrawalRequest = new WithdrawalRequest($db);

try {
    $status_filter = isset($_GET['status']) ? $_GET['status'] : null;
    $offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;
    $limit = isset($_GET['limit']) ? intval($_GET['limit']) : 20;

    $withdrawals = $withdrawalRequest->getAllWithUserInfo($offset, $limit, $status_filter);

    echo json_encode([
        'success' => true,
        'withdrawals' => $withdrawals
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching withdrawal requests: ' . $e->getMessage()
    ]);
}
