<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

require_once '../config/database.php';
require_once '../models/User.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$database = new Database();
$db = $database->getConnection();

$user = new User($db);

$data = json_decode(file_get_contents("php://input"));

if (!$data || !isset($data->device_id)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Device ID is required']);
    exit;
}

$user->device_id = $data->device_id;

// Check if user exists
if ($user->readByDeviceId()) {
    // User exists, return user data
    echo json_encode([
        'success' => true,
        'message' => 'User authenticated successfully',
        'user' => [
            'id' => $user->id,
            'username' => $user->username,
            'email' => $user->email,
            'total_playtime_minutes' => $user->total_playtime_minutes,
            'current_balance' => floatval($user->current_balance),
            'total_earned' => floatval($user->total_earned),
            'total_withdrawn' => floatval($user->total_withdrawn),
            'admob_earnings' => floatval($user->admob_earnings),
            'status' => $user->status
        ]
    ]);
} else {
    // Create new user if username and email provided
    if (isset($data->username) && isset($data->email)) {
        $user->username = $data->username;
        $user->email = $data->email;
        $user->password_hash = password_hash($data->device_id, PASSWORD_DEFAULT);

        if ($user->create()) {
            echo json_encode([
                'success' => true,
                'message' => 'User created successfully',
                'user' => [
                    'id' => $user->id,
                    'username' => $user->username,
                    'email' => $user->email,
                    'total_playtime_minutes' => 0,
                    'current_balance' => 0.00,
                    'total_earned' => 0.00,
                    'total_withdrawn' => 0.00,
                    'admob_earnings' => 0.00,
                    'status' => 'active'
                ]
            ]);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Failed to create user']);
        }
    } else {
        http_response_code(404);
        echo json_encode(['success' => false, 'message' => 'User not found. Username and email required for registration.']);
    }
}
